/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lane.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.BooleanInput;
import ibm.nways.jdm.eui.BooleanInputRO;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import ibm.nways.lane.model.LeArpModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class LeArpPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "LAN Emulation ARP Table";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel LeArp_model;
    protected selectionListSection selectionListPropertySection;
    protected LeArpDetailsSection LeArpDetailsPropertySection;
    protected ModelInfo LeArpTableInfo;
    protected ModelInfo PanelInfo;
    protected ModelInfo IndexInfo;
    protected int LeArpTableIndex;
    protected LeArpTable LeArpTableData;
    protected TableColumns LeArpTableColumns;
    protected TableStatus LeArpTableStatus;
    protected static TableColumn[] LeArpTableCols = new TableColumn[]{new TableColumn("Index.LecIndex", "LEC Index", 3, true), new TableColumn("Index.LeArpMacAddress", "MAC Address", 9, true), new TableColumn("Panel.LeArpAtmAddress", "ATM Address", 9, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.lane.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.lane.eui.LeArpPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel LeArp");
        }
    }

    public static String getTitle() {
        LeArpPanel.loadStatics();
        if (myResources != null) {
            title = LeArpPanel.getNLSString("LeArpPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            LeArpPanel.loadStatics();
        }
        return enumStrings;
    }

    public LeArpPanel() {
        LeArpPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return LeArpPanel.getTitle();
    }

    protected void getModels() {
        this.LeArp_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addLeArpDetailsSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(LeArpPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addLeArpDetailsSection() {
        this.LeArpDetailsPropertySection = new LeArpDetailsSection();
        this.LeArpDetailsPropertySection.layoutSection();
        this.addSection(LeArpPanel.getNLSString("LeArpDetailsSectionTitle"), this.LeArpDetailsPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.LeArpDetailsPropertySection != null) {
            this.LeArpDetailsPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialLeArpTableRow() {
        return 0;
    }

    public ModelInfo initialLeArpTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(LeArpPanel.getNLSString("startResetMsg"));
        this.LeArpTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(LeArpPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(LeArpPanel.getNLSString("endResetMsg")) + " " + LeArpPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.IndexInfo = new ModelInfo();
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.LecIndex", (Serializable)this.LeArpTableData.getValueAt("Index.LecIndex", this.LeArpTableIndex));
        this.PanelInfo.add("Index.LeArpMacAddress", (Serializable)this.LeArpTableData.getValueAt("Index.LeArpMacAddress", this.LeArpTableIndex));
        this.errorsFound = false;
        this.displayMsg(LeArpPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.LeArpTableInfo = (ModelInfo)this.LeArpTableData.elementAt(this.LeArpTableIndex);
            this.LeArpTableInfo = this.LeArpTableData.setRow();
            this.LeArpTableData.setElementAt(this.LeArpTableInfo, this.LeArpTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(LeArpPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(LeArpPanel.getNLSString("endApplyMsg")) + " " + LeArpPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(LeArpPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.LeArpTableData = new LeArpTable();
        this.LeArpTableIndex = 0;
        this.LeArpTableColumns = new TableColumns(LeArpTableCols);
        if (this.LeArp_model instanceof RemoteModelWithStatus) {
            try {
                this.LeArpTableStatus = (TableStatus)this.LeArp_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component LeArpTableField;
        Label LeArpTableFieldLabel;
        boolean LeArpTableFieldWritable = false;

        public selectionListSection() {
            LeArpPanel.this = LeArpPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createLeArpTableField() {
            EuiGrid euiGrid = new EuiGrid(LeArpPanel.this.LeArpTableData, LeArpPanel.this.LeArpTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(LeArpPanel.this.initialLeArpTableRow());
            this.addTable(LeArpPanel.getNLSString("LeArpTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.LeArpTableField = this.createLeArpTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                LeArpPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("accessDataMsg"));
            LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.LeArpTableField).refresh();
            LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("endTableGetMsg"));
            LeArpPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.LeArpTableField) {
                        LeArpPanel.this.LeArpTableIndex = euiGridEvent.getRow();
                    }
                    LeArpPanel.this.LeArpTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.LeArpTableField).deselectAllRows();
                    LeArpPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.LeArpTableField) {
                        LeArpPanel.this.LeArpTableIndex = 0;
                    }
                    LeArpPanel.this.selectionListPropertySection.reset();
                    LeArpPanel.this.LeArpDetailsPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class LeArpDetailsSection
    extends PropertySection {
        ModelInfo chunk;
        Component leArpIndexField;
        Component leArpIfDescrField;
        Component leArpMacAddressField;
        Component leArpAtmAddressField;
        Component leArpIsRemoteAddressField;
        Component leArpEntryTypeField;
        Label leArpIndexFieldLabel;
        Label leArpIfDescrFieldLabel;
        Label leArpMacAddressFieldLabel;
        Label leArpAtmAddressFieldLabel;
        Label leArpIsRemoteAddressFieldLabel;
        Label leArpEntryTypeFieldLabel;
        boolean leArpIndexFieldWritable = false;
        boolean leArpIfDescrFieldWritable = false;
        boolean leArpMacAddressFieldWritable = false;
        boolean leArpAtmAddressFieldWritable = false;
        boolean leArpIsRemoteAddressFieldWritable = false;
        boolean leArpEntryTypeFieldWritable = false;

        public LeArpDetailsSection() {
            LeArpPanel.this = LeArpPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createleArpIndexField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Index.LecIndex.access", "unknown");
            this.leArpIndexFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpIndexFieldLabel = new Label(LeArpPanel.getNLSString("leArpIndexLabel"), 2);
            if (this.leArpIndexFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, Integer.MAX_VALUE);
                this.addRow(this.leArpIndexFieldLabel, (Component)numericInput);
                LeArpPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.leArpIndexFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getleArpIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIndexField);
            this.validateleArpIndexField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpIndexField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpIndexField);
                jDMInput.setValue(object);
                this.validateleArpIndexField();
            }
        }

        protected boolean validateleArpIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIndexField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpIndexFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpIndexFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createleArpIfDescrField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LecIfDescr.access", "read-only");
            String string2 = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LecIfDescr.length", "255");
            this.leArpIfDescrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpIfDescrFieldLabel = new Label(LeArpPanel.getNLSString("leArpIfDescrLabel"), 2);
            if (this.leArpIfDescrFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.leArpIfDescrFieldLabel, (Component)stringInput);
                LeArpPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.leArpIfDescrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getleArpIfDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIfDescrField);
            this.validateleArpIfDescrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpIfDescrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpIfDescrField);
                jDMInput.setValue(object);
                this.validateleArpIfDescrField();
            }
        }

        protected boolean validateleArpIfDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIfDescrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpIfDescrFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpIfDescrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createleArpMacAddressField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Index.LeArpMacAddress.access", "unknown");
            String string2 = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Index.LeArpMacAddress.length", "6");
            this.leArpMacAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpMacAddressFieldLabel = new Label(LeArpPanel.getNLSString("leArpMacAddressLabel"), 2);
            if (this.leArpMacAddressFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.leArpMacAddressFieldLabel, (Component)hexInput);
                LeArpPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.leArpMacAddressFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getleArpMacAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpMacAddressField);
            this.validateleArpMacAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpMacAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpMacAddressField);
                jDMInput.setValue(object);
                this.validateleArpMacAddressField();
            }
        }

        protected boolean validateleArpMacAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpMacAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpMacAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpMacAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createleArpAtmAddressField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LeArpAtmAddress.access", "read-write");
            String string2 = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LeArpAtmAddress.length", "20");
            this.leArpAtmAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpAtmAddressFieldLabel = new Label(LeArpPanel.getNLSString("leArpAtmAddressLabel"), 2);
            if (this.leArpAtmAddressFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.leArpAtmAddressFieldLabel, (Component)hexInput);
                LeArpPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.leArpAtmAddressFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getleArpAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpAtmAddressField);
            this.validateleArpAtmAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpAtmAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpAtmAddressField);
                jDMInput.setValue(object);
                this.validateleArpAtmAddressField();
            }
        }

        protected boolean validateleArpAtmAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpAtmAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpAtmAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpAtmAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createleArpIsRemoteAddressField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LeArpIsRemoteAddress.access", "read-only");
            this.leArpIsRemoteAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpIsRemoteAddressFieldLabel = new Label(LeArpPanel.getNLSString("leArpIsRemoteAddressLabel"), 2);
            if (this.leArpIsRemoteAddressFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.leArpIsRemoteAddressFieldLabel, (Component)booleanInput);
                LeArpPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.leArpIsRemoteAddressFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getleArpIsRemoteAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIsRemoteAddressField);
            this.validateleArpIsRemoteAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpIsRemoteAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpIsRemoteAddressField);
                jDMInput.setValue(object);
                this.validateleArpIsRemoteAddressField();
            }
        }

        protected boolean validateleArpIsRemoteAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpIsRemoteAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpIsRemoteAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpIsRemoteAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createleArpEntryTypeField() {
            String string = LeArpPanel.this.getOverride("ibm.nways.lane.model.LeArp.Panel.LeArpEntryType.access", "read-write");
            this.leArpEntryTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.leArpEntryTypeFieldLabel = new Label(LeArpPanel.getNLSString("leArpEntryTypeLabel"), 2);
            if (this.leArpEntryTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LeArpModel.Panel.LeArpEntryTypeEnum.symbolicValues, LeArpModel.Panel.LeArpEntryTypeEnum.numericValues, LeArpPanel.getEnumStrings());
                this.addRow(this.leArpEntryTypeFieldLabel, (Component)singleChoiceInput);
                LeArpPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LeArpModel.Panel.LeArpEntryTypeEnum.symbolicValues, LeArpModel.Panel.LeArpEntryTypeEnum.numericValues, LeArpPanel.getEnumStrings());
            this.addRow(this.leArpEntryTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getleArpEntryTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpEntryTypeField);
            this.validateleArpEntryTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setleArpEntryTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.leArpEntryTypeField);
                jDMInput.setValue(object);
                this.validateleArpEntryTypeField();
            }
        }

        protected boolean validateleArpEntryTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.leArpEntryTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.leArpEntryTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.leArpEntryTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.leArpIndexField = this.createleArpIndexField();
            this.leArpIfDescrField = this.createleArpIfDescrField();
            this.leArpMacAddressField = this.createleArpMacAddressField();
            this.leArpAtmAddressField = this.createleArpAtmAddressField();
            this.leArpIsRemoteAddressField = this.createleArpIsRemoteAddressField();
            this.leArpEntryTypeField = this.createleArpEntryTypeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.leArpIndexField)).ignoreValue() && this.leArpIndexFieldWritable) {
                    LeArpPanel.this.IndexInfo.add("Index.LecIndex", this.getleArpIndexField());
                }
                if (!((JDMInput)((Object)this.leArpIfDescrField)).ignoreValue() && this.leArpIfDescrFieldWritable) {
                    LeArpPanel.this.PanelInfo.add("Panel.LecIfDescr", this.getleArpIfDescrField());
                }
                if (!((JDMInput)((Object)this.leArpMacAddressField)).ignoreValue() && this.leArpMacAddressFieldWritable) {
                    LeArpPanel.this.IndexInfo.add("Index.LeArpMacAddress", this.getleArpMacAddressField());
                }
                if (!((JDMInput)((Object)this.leArpAtmAddressField)).ignoreValue() && this.leArpAtmAddressFieldWritable) {
                    LeArpPanel.this.PanelInfo.add("Panel.LeArpAtmAddress", this.getleArpAtmAddressField());
                }
                if (!((JDMInput)((Object)this.leArpIsRemoteAddressField)).ignoreValue() && this.leArpIsRemoteAddressFieldWritable) {
                    LeArpPanel.this.PanelInfo.add("Panel.LeArpIsRemoteAddress", this.getleArpIsRemoteAddressField());
                }
                if (!((JDMInput)((Object)this.leArpEntryTypeField)).ignoreValue() && this.leArpEntryTypeFieldWritable) {
                    LeArpPanel.this.PanelInfo.add("Panel.LeArpEntryType", this.getleArpEntryTypeField());
                    return;
                }
            } else {
                LeArpPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("accessDataMsg"));
            try {
                this.setleArpIndexField(LeArpPanel.this.LeArpTableData.getValueAt("Index.LecIndex", LeArpPanel.this.LeArpTableIndex));
                this.setleArpIfDescrField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LecIfDescr", LeArpPanel.this.LeArpTableIndex));
                this.setleArpMacAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Index.LeArpMacAddress", LeArpPanel.this.LeArpTableIndex));
                this.setleArpAtmAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpAtmAddress", LeArpPanel.this.LeArpTableIndex));
                this.setleArpIsRemoteAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpIsRemoteAddress", LeArpPanel.this.LeArpTableIndex));
                this.setleArpEntryTypeField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpEntryType", LeArpPanel.this.LeArpTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            LeArpPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setleArpIndexField(LeArpPanel.this.LeArpTableData.getValueAt("Index.LecIndex", LeArpPanel.this.LeArpTableIndex));
            this.setleArpIfDescrField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LecIfDescr", LeArpPanel.this.LeArpTableIndex));
            this.setleArpMacAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Index.LeArpMacAddress", LeArpPanel.this.LeArpTableIndex));
            this.setleArpAtmAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpAtmAddress", LeArpPanel.this.LeArpTableIndex));
            this.setleArpIsRemoteAddressField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpIsRemoteAddress", LeArpPanel.this.LeArpTableIndex));
            this.setleArpEntryTypeField(LeArpPanel.this.LeArpTableData.getValueAt("Panel.LeArpEntryType", LeArpPanel.this.LeArpTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.leArpAtmAddressField)).ignoreValue() && !this.validateleArpAtmAddressField()) {
                return false;
            }
            return ((JDMInput)((Object)this.leArpEntryTypeField)).ignoreValue() || this.validateleArpEntryTypeField();
        }
    }

    public class LeArpTable
    extends Table {
        public ModelInfo setRow() {
            try {
                LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("startSendMsg"));
                LeArpPanel.this.PanelInfo = LeArpPanel.this.LeArp_model.setInfo("Panel", LeArpPanel.this.PanelInfo);
                LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("endSendMsg"));
                if (LeArpPanel.this.PanelInfo != null) {
                    Enumeration enumeration = LeArpPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LeArpPanel.this.PanelInfo.get(string);
                        LeArpPanel.this.LeArpTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LeArpPanel.this.LeArpTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    LeArpPanel.this.LeArpTableInfo = null;
                    LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("startRow"));
                    LeArpPanel.this.PanelInfo = LeArpPanel.this.LeArp_model.getNextInfo("Panel", "default", modelInfo);
                    LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("endRow"));
                    if (LeArpPanel.this.PanelInfo != null) {
                        LeArpPanel.this.LeArpTableInfo = new ModelInfo();
                        if (LeArpPanel.this.PanelInfo.isBeingMonitored()) {
                            LeArpPanel.this.LeArpTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = LeArpPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = LeArpPanel.this.PanelInfo.get(string);
                            LeArpPanel.this.LeArpTableInfo.add(string, serializable);
                        }
                    }
                    if (LeArpPanel.this.LeArpTableInfo != null && !this.validRow(LeArpPanel.this.LeArpTableInfo)) {
                        modelInfo = LeArpPanel.this.LeArpTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LeArpPanel.this.LeArpTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            LeArpPanel.this.LeArpTableInfo = null;
            try {
                LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("startRow"));
                LeArpPanel.this.PanelInfo = LeArpPanel.this.LeArp_model.getInfo("Panel", "default", modelInfo);
                LeArpPanel.this.displayMsg(LeArpPanel.getNLSString("endRow"));
                if (LeArpPanel.this.PanelInfo != null) {
                    LeArpPanel.this.LeArpTableInfo = new ModelInfo();
                    if (LeArpPanel.this.PanelInfo.isBeingMonitored()) {
                        LeArpPanel.this.LeArpTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = LeArpPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LeArpPanel.this.PanelInfo.get(string);
                        LeArpPanel.this.LeArpTableInfo.add(string, serializable);
                    }
                }
                if (LeArpPanel.this.LeArpTableInfo != null && !this.validRow(LeArpPanel.this.LeArpTableInfo)) {
                    LeArpPanel.this.LeArpTableInfo = this.getRow(LeArpPanel.this.LeArpTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LeArpPanel.this.LeArpTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (LeArpPanel.this.LeArpTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            LeArpPanel.this.LeArpTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        LeArpPanel.this.LeArpTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        LeArpPanel.this.LeArpTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    LeArpPanel.this.LeArpTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            return string2;
        }

        public LeArpTable() {
            LeArpPanel.this = LeArpPanel.this;
        }
    }
}

